package easik.ui.tree.popup;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.tree.DefaultMutableTreeNode;

import easik.Easik;
import easik.sketch.Sketch;
import easik.sketch.constraint.Constraint;

/**
 * Action for the delete constraint option in the popup menu.
 * 
 * @author Kevin Green 2006
 * @since 2006-08-02 Kevin Green
 * @version 2006-08-02 Kevin Green
 */
public class DeleteConstraintAction extends AbstractAction{

	/**
	 * Sets up delete constraint action
	 */
	public DeleteConstraintAction(){
		super("Delete Constraint");	
		putValue(AbstractAction.MNEMONIC_KEY, new Integer(KeyEvent.VK_D));
		putValue(AbstractAction.SHORT_DESCRIPTION, "Deletes the currently selected constraint");
	}
	
	/**
	 * Called when clicked upon, will delete constraint. 
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		//If there is nothing seleceted then just do nothing
		if(Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().isSelectionEmpty())
		{
			return;
		}
		
		//Get currently selected object
		DefaultMutableTreeNode curSelectedNode = (DefaultMutableTreeNode) 
					Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().getSelectionPath().getLastPathComponent();
		Object curSelected = curSelectedNode.getUserObject();
		
		if(curSelected instanceof Constraint){
			Easik.getInstance().getFrame().getSketch().removeConstraint((Constraint)curSelected);
			
			Easik.getInstance().getFrame().getSketch().setDirty(true);
		}
	}
}
